COMMENT: This syntax replicates the results of Table 7-5; the dichotomous factors are the covariates
of Culture, the BIC statistic differs slightly from the SAS results.

COMMENT: This syntax is copyright by Robert B. Smith,  2011.

WEIGHT Off.
 
Comment: HDI Rank is the response variable.
MIXED HDIRANK BY CULTURE WITH emancip dichofre lodebt nochaos integrit
  /CRITERIA=CIN(95) MXITER(100) MXSTEP(10) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, 
    ABSOLUTE) LCONVERGE(0, ABSOLUTE) PCONVERGE(0.000001, ABSOLUTE)
  /FIXED=CULTURE emancip dichofre lodebt nochaos integrit | SSTYPE(3)
  /METHOD=REML
  /PRINT=SOLUTION TESTCOV
  /RANDOM=INTERCEPT | SUBJECT(REGION) COVTYPE(VC)
  /REGWGT=Sqrtpop
  /EMMEANS=TABLES(CULTURE) .


Comment: HDI Scores is the response variable.
MIXED HDIIndex BY CULTURE WITH emancip dichofre lodebt nochaos integrit
  /CRITERIA=CIN(95) MXITER(100) MXSTEP(10) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, 
    ABSOLUTE) LCONVERGE(0, ABSOLUTE) PCONVERGE(0.000001, ABSOLUTE)
  /FIXED=CULTURE emancip dichofre lodebt nochaos integrit | SSTYPE(3)
  /METHOD=REML
  /PRINT=SOLUTION TESTCOV
  /RANDOM=INTERCEPT | SUBJECT(REGION) COVTYPE(VC)
  /REGWGT=Sqrtpop
  /EMMEANS=TABLES(CULTURE) .

Comment: Longevity Scores is the response variable.
MIXED LIFIndex BY CULTURE WITH emancip dichofre lodebt nochaos integrit
  /CRITERIA=CIN(95) MXITER(100) MXSTEP(10) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, 
    ABSOLUTE) LCONVERGE(0, ABSOLUTE) PCONVERGE(0.000001, ABSOLUTE)
  /FIXED=CULTURE emancip dichofre lodebt nochaos integrit | SSTYPE(3)
  /METHOD=REML
  /PRINT=SOLUTION TESTCOV
  /RANDOM=INTERCEPT | SUBJECT(REGION) COVTYPE(VC)
  /REGWGT=Sqrtpop
  /EMMEANS=TABLES(CULTURE) .


Comment: Literacy Scores is the response variable.
MIXED EDUIndex BY CULTURE WITH emancip dichofre lodebt nochaos integrit
  /CRITERIA=CIN(95) MXITER(100) MXSTEP(10) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, 
    ABSOLUTE) LCONVERGE(0, ABSOLUTE) PCONVERGE(0.000001, ABSOLUTE)
  /FIXED=CULTURE emancip dichofre lodebt nochaos integrit | SSTYPE(3)
  /METHOD=REML
  /PRINT=SOLUTION TESTCOV
  /RANDOM=INTERCEPT | SUBJECT(REGION) COVTYPE(VC)
  /REGWGT=Sqrtpop
  /EMMEANS=TABLES(CULTURE) .

Comment: GDP is the response variable.
MIXED GDPIndex BY CULTURE WITH emancip dichofre lodebt nochaos integrit
  /CRITERIA=CIN(95) MXITER(100) MXSTEP(10) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, 
    ABSOLUTE) LCONVERGE(0, ABSOLUTE) PCONVERGE(0.000001, ABSOLUTE)
  /FIXED=CULTURE emancip dichofre lodebt nochaos integrit | SSTYPE(3)
  /METHOD=REML
  /PRINT=SOLUTION TESTCOV
  /RANDOM=INTERCEPT | SUBJECT(REGION) COVTYPE(VC)
  /REGWGT=Sqrtpop
  /EMMEANS=TABLES(CULTURE) .

Comment: These unweighted standard deviations are the same as unweighted SDs from SAS but differ
from the SAS weighted SDs by a factor of about 2, SPSS does not weight the SDs the same way as SAS.
COMMENT. The weighted SAS SDs in Table7-5 are correct.

WEIGHT OFF.
DESCRIPTIVES VARIABLES=HDIRANK HDIINDEX LIFIndex EDUIndex GDPIndex
 /STATISTICS=MEAN STDDEV MIN MAX.
 


